<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query;
use EshopCatalog\FrontModule\Model\Products;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItemTexts;

class Orders extends BaseFrontEntityService
{
	/** @var string */
	public $entityClass = Order::class;

	/** @var Products */
	protected $products;

	public function __construct(Products $products)
	{
		$this->products = $products;
	}

	public function getDetail(int $id)
	{
		$order = $this->getEr()->createQueryBuilder('o')
			->addSelect('c, pay, sped, items, itemsTxt, disc, del, inv, oStat, stat')
			->innerJoin('o.customer', 'c')
			->innerJoin('o.payment', 'pay')
			->innerJoin('o.spedition', 'sped')
			->innerJoin('o.orderItems', 'items')
			->leftJoin('items.orderItemTexts', 'itemsTxt', 'WITH', 'itemsTxt.lang = :lang')
			->setParameter('lang', $this->translator->getLocale())
			->leftJoin('o.orderDiscounts', 'disc')
			->leftJoin('o.addressInvoice', 'inv')
			->leftJoin('o.addressDelivery', 'del')
			->innerJoin('o.orderStatuses', 'oStat')
			->innerJoin('oStat.status', 'stat')
			->where('o.id = :id')->setParameter('id', $id)
			->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);

		if (!$order)
			return null;

		if (!$order['addressDelivery'])
			$order['addressDelivery'] = $order['addressInvoice'];

		if ($order['orderItems'] && empty(array_values($order['orderItems'])[0]['orderItemTexts'])) {
			$texts = $this->em->getRepository(OrderItemTexts::class)->createQueryBuilder('oit')
				->where('oit.id IN (:ids)')
				->setParameter('ids', array_keys($order['orderItems']))
				->groupBy('oit.id')
				->getQuery()->getArrayResult();

			foreach ($texts as $v) {
				$order['orderItems'][$v['id']]['orderItemTexts'][$this->translator->getLocale()] = $v;
			}
		}

		$itemsPrice = 0;
		foreach ($order['orderItems'] as $k => &$v) {
			$p = $this->products->get($v['productId']);
			if ($p)
				$v['product'] = $p;
			$v['text'] = $v['orderItemTexts'][$this->translator->getLocale()];
			unset($v['orderItemTexts']);

			foreach ($v['orderStatuses'] as $ks => $s) {
				if ($s['deleted'])
					unset($v['orderStatuses'][$ks]);
			}

			$itemsPrice += (float) round($v['price'] * $v['quantity'], 2);
		}
		$order['itemsPrice']                = $itemsPrice;
		$order['totalPriceWithoutDiscount'] = $itemsPrice + (float) $order['spedition']['price'] + (float) $order['payment']['price'];

		return $order;
	}
}
