<?php declare(strict_types=1);

namespace EshopOrders\Model\Utils;

use Core\Model\Templating\Filters\Price;
use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Entities\OrderDiscount;

class Helpers
{
	/** @var Price */
	protected $priceFilter;

	/**
	 * Helpers constructor.
	 * @param Price $priceFilter
	 */
	public function __construct(Price $priceFilter)
	{
		$this->priceFilter = $priceFilter;
	}

	/**
	 * @param string $input
	 * @param array $timeWildcards
	 * @return string
	 */
	public static function replaceTimeWildcards(string $input, array $timeWildcards): string
	{
		foreach ($timeWildcards as $item) {
			switch ($item) {
				case 'YYYY':
					$input = str_replace('YYYY', date('Y'), $input);
					break;
				case 'YY':
					$input = str_replace('YY', date('y'), $input);
					break;
				case 'MM':
					$input = str_replace('MM', date('m'), $input);
					break;
			}
		}

		return $input;
	}

	/**
	 * @param IDiscount $discount
	 * @return string
	 */
	public function formatDiscount(IDiscount $discount): string
	{
		if ($discount->getType() === OrderDiscount::TYPE_FIX) {
			return $this->priceFilter->format($discount->getValue());
		}

		// type percent
		return sprintf('%s %s', $discount->getValue(), '%');
	}

}