document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name !== 'packageBoxProduct') {
		return;
	}

	const resp      = e;
	const input     = resp.target;
	const selection = resp.detail.selection;

	input.value = '';

	const table = document.querySelector('[data-target="' + input.id + '"]');

	if (!table) {
		return;
	}

	addRow(
		table,
		input.dataset.packageContainerName,
		selection.value.id,
		selection.value.code1,
		selection.value.name,
	);
});

const addRow = (table, containerName, id, code1, name) => {
	const tr = document.createElement('tr');
	tr.setAttribute('data-id', id);

	const tdCode     = document.createElement('td');
	tdCode.innerText = code1;

	const tdName     = document.createElement('td');
	tdName.innerHTML = '<input name="' + containerName + '[' + id + ']" type="hidden" value="' + id + '">' + name;

	const tdAction     = document.createElement('td');
	tdAction.className = 'col-action';
	tdAction.innerHTML = '<span class="handle-sort btn btn-xs btn-default btn-secondary"><i class="fas fa-sort"></i></span> ' +
	                     '<a href="javascript:;" class="btn btn-xs btn-danger" data-remove-table-tr><i class="fas fa-times"></i></a>';

	tr.appendChild(tdCode);
	tr.appendChild(tdName);
	tr.appendChild(tdAction);

	table.querySelector('tbody').appendChild(tr);

}
