const calculateOffsets = () => {
	let linkOffsets = [];

	document.querySelectorAll('.product-list__wrap li a').forEach(link => {
		let hrefAttr = link.getAttribute('href');
		let el       = document.getElementById(hrefAttr.substr(1));

		if (!el)
			return true;

		linkOffsets[hrefAttr] = {
			offsetTop: el.getBoundingClientRect().top + window.scrollY,
			link     : link,
		}
	});

	return linkOffsets;
}

// Nastaveni pozice panelu pro prepinani kategorie
const productListWrap = document.querySelector('.product-list__wrap');
if (productListWrap) {
	let productListWrapBounding  = productListWrap.getBoundingClientRect();
	let productListWrapTopOffset = productListWrapBounding.top + window.scrollY;
	let topPanel                 = document.getElementById('top-panel');
	let topPanelHeight           = topPanel ? topPanel.getBoundingClientRect().height : 0;

	let productListWrapGhost          = productListWrap.nextElementSibling;
	productListWrapGhost.style.height = productListWrapBounding.height + 'px';

	let linkOffsets = calculateOffsets();

	setTimeout(e => {
		linkOffsets = calculateOffsets();
	}, 1200);

	document.querySelectorAll('.product-list__wrap li a ').forEach(link => {
		link.addEventListener('click', e => {
			linkOffsets = calculateOffsets();
		});
	});

	window.addEventListener('scroll', e => {
		let topScroll = window.pageYOffset + topPanelHeight;

		if (topScroll > productListWrapTopOffset) {
			productListWrap.classList.add('fixed');
		} else {
			productListWrap.classList.remove('fixed');
		}

		// Scrollspy
		topScroll += productListWrapBounding.height;
		let activeLink = null;

		for (let k in linkOffsets) {
			let row = linkOffsets[k];

			row.link.classList.remove('active');

			if (topScroll > row.offsetTop - 65) {
				activeLink = row.link;
			}
		}

		if (activeLink) {
			activeLink.classList.add('active');
		}
	});
}
