import Cart     from "./components/Cart";
import {tns}    from "tiny-slider/src/tiny-slider";
import {Fancybox} from "@fancyapps/ui";

const initGallery = () => {
	let productGallery = document.querySelector('.prod__gallery');
	if (productGallery) {
		if (productGallery.inited === true)
			return true;
		productGallery.inited = true;

		let productGallerySlider = tns({
			container   : productGallery,
			items       : 1,
			loop        : false,
			controlsText: ['', ''],
			speed       : 500,
		});
	}
}

document.addEventListener('click', e => {
	const target = e.target;

	if (target.matches('.product-preview__name')) {
		e.preventDefault();

		Fancybox.show([{
			type: 'ajax',
			src : target.href,
		}], {
			arrows: false,
			touch: false,
			afterLoad: (i, item) => {
				initGallery();
			},
		});

		return false;
	}
});

const main = document.querySelector('.eshopPackage-cart');

if (main) {
	const cart = new Cart(main);
}
