<?php declare(strict_types = 1);

namespace EshopPackages\AdminModule\Components\Packages;

use Core\Model\Helpers\Strings;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopPackages\AdminModule\Model\Services\EditablePackagesService;
use EshopPackages\Model\Entities\EditablePackage;
use EshopPackages\Model\Services\PackageProducts;
use Exception;
use Nette\Utils\ArrayHash;
use Nette\Utils\Json;

class ProductsSort extends BaseControl
{
	/** @var int @persistent */
	public $packageId;

	protected ?EditablePackage        $editablePackage = null;
	protected EditablePackagesService $editablePackagesService;
	protected PackageProducts         $packageProducts;

	public function __construct(
		EditablePackagesService $editablePackagesService,
		PackageProducts         $packageProducts
	)
	{
		$this->editablePackagesService = $editablePackagesService;
		$this->packageProducts         = $packageProducts;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function getEditablePackage(): EditablePackage
	{
		if ($this->editablePackage === null) {
			$this->editablePackage = $this->editablePackagesService->get($this->packageId);
		}

		return $this->editablePackage;
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$sorts       = $form->addContainer('sorts');
		$package     = $this->getEditablePackage();
		$packageSort = $package->getAttr('productsSort') ? Json::decode($package->getAttr('productsSort'), Json::FORCE_ARRAY) : [];
		$packages    = $this->packageProducts->getProductsForEditablePackage($package)
			+ $this->packageProducts->getProductsForEditablePackage($package, true);

		foreach ($packages as $name => $rows) {
			$camelCaseName = Strings::toCamelCase($name);
			$products      = [];
			$tmp           = [];

			/** @var Product $row */
			foreach ($rows as $row) {
				$products[$row->getId()] = $row->getName();
				$tmp[$row->getId()]      = $row->getName();
			}

			$ordered = [];
			foreach ($packageSort[$camelCaseName] as $key) {
				if (isset($tmp[$key])) {
					$ordered[$key] = $products[$key];
					unset($tmp[$key]);
				}
			}

			$sorts->addSortableCheckboxList($camelCaseName, $name, $products)
				->setDefaultValue(array_keys($ordered + $tmp));
		}

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$package = $this->getEditablePackage();
			$package->setAttr('productsSort', Json::encode((array) $values->sorts));

			$this->em->persist($package);
			$this->em->flush();

			$this->presenter->flashMessageSuccess('default.saved');

			return true;
		} catch (Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');
		}

		return false;
	}

}
