<?php declare(strict_types = 1);

namespace EshopPackages\AdminModule\Model\Services;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Query\Expr\Join;
use EshopPackages\Model\Entities\EditablePackage;
use Contributte\Translation\Translator;

/**
 * @method EditablePackage[] getAll()
 * @method EditablePackage getReference($id)
 */
class EditablePackagesService extends BaseEntityService
{
	protected $entityClass = EditablePackage::class;
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param int|string $id
	 * @throws NonUniqueResultException
	 */
	public function get($id): ?EditablePackage
	{
		return $this->getEr()->createQueryBuilder('ep')
			->where('ep.id = :id')
			->setParameter('id', $id)
			->setMaxResults(1)->getQuery()->getOneOrNullResult();
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('ep')
			         ->select('ep.id, ept.title')
			         ->innerJoin('ep.texts', 'ept', Join::WITH, 'ept.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['id']] = $row['title'];
		}

		return $arr;
	}
}
