<?php declare(strict_types = 1);

namespace EshopPackages\AdminModule\Presenters;

use EshopPackages\AdminModule\Components\Packages\IEditablePackagesGridFactory;
use EshopPackages\AdminModule\Components\Packages\EditablePackagesGrid;

class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopPackages.title.packages', 'fas fa-box-open');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopPackages.menu.addEditablePackage',
				'link'  => $this->link('editablePackagesGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentEditablePackagesGrid(IEditablePackagesGridFactory $factory): EditablePackagesGrid
	{
		return $factory->create();
	}
}
