<?php declare(strict_types = 1);

namespace EshopPackages\CronModule\Presenters;

use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Dao\AddedCartItem;
use EshopOrders\FrontModule\Model\Event\AddedCartItemEvent;
use EshopOrders\FrontModule\Model\Event\RemovedCartItemEvent;
use EshopPackages\Model\Helper;

class DefaultPresenter extends BasePresenter
{
	/** @var CartFacade|null @inject */
	public ?CartFacade $cartFacade = null;

	/** @var Products|null @inject */
	public ?Products $products = null;

	/** @var ProductsFacade|null @inject */
	public ?ProductsFacade $productsFacade = null;

	/** @var Helper|null @inject */
	public ?Helper $helper = null;

	public function actionAddToCartEditablePackage(int $id): void
	{
		$items = $this->getHttpRequest()->getPost('items');

		if (empty($items)) {
			exit;
		}

		$baseProductId = $this->getParameter('baseProduct');
		if (!$baseProductId) {
			$baseProductId = $this->helper->getProductByEditablePackage($id);
		}

		$baseProduct = $baseProductId ? $this->products->get((int) $baseProductId) : null;
		/** @var Product|null $productDao */
		$productDao = $this->productsFacade->getProduct((int) $baseProductId);

		if (!$baseProduct || !$productDao) {
			exit;
		}

		$cartItem = $this->getParameter('cartItem');
		if ($cartItem) {
			$item = new RemovedCartItemEvent((int) $cartItem);
			$this->eventDispatcher->dispatch($item, 'eshopOrders.cartRemoveItem');
			$this->products->em->clear();
		}

		$uniqId = uniqid();

		$baseItem                              = new AddedCartItem;
		$baseItem->vatRate                     = $productDao->vatRate;
		$baseItem->optionId                    = $uniqId;
		$baseItem->quantity                    = 1;
		$baseItem->price                       = 0;
		$baseItem->name                        = $productDao->getName();
		$baseItem->moreData                    = [
			'isPackageParent'    => true,
			'baseQuantity'       => 1,
			'useThisPrice'       => 1,
			'productId'          => $productDao->getId(),
			'isCustom'           => true,
			'disableProductLink' => true,
			'link'               => [
				'link' => $this->link(':EshopPackages:Front:Default:editablePackage', [
					'id'       => $id,
					'cartItem' => '__cartItem__',
				]),
				'text' => $this->translator->translate('eshopPackagesFront.cart.editPackage'),
			],
		];
		$baseItem->ignoreValidation            = true;
		$baseItem->moreData['disableStacking'] = true;

		if ($productDao->getGallery() && $productDao->getGallery()->getCover()) {
			$baseItem->image = $productDao->getGallery()->getCover()->getFilePath();
		}

		$this->eventDispatcher->dispatch(new AddedCartItemEvent($baseItem), 'eshopOrders.cartAddItem');

		$items1 = [];
		$items2 = [];

		foreach ($items as $v) {
			if ($v['data']['section'] == 2) {
				$items2[] = $v;
			} else {
				$items1[] = $v;
			}
		}

		$box                              = new AddedCartItem;
		$box->price                       = $productDao->getPrice();
		$box->quantity                    = 1;
		$box->productId                   = $productDao->getId();
		$box->parentId                    = (int) $baseItem->itemId;
		$box->moreData['baseQuantity']    = 1;
		$box->moreData['disableStacking'] = true;
		$box->name                        = $this->translator->translate('eshopPackagesFront.editablePackage.box');
		$this->eventDispatcher->dispatch(new AddedCartItemEvent($box), 'eshopOrders.cartAddItem');

		foreach (array_merge($items1, $items2) as $item) {
			$addedItem            = new AddedCartItem;
			$addedItem->productId = (int) $item['itemId'];
			$addedItem->quantity  = (int) $item['quantity'];
			$addedItem->parentId  = (int) $baseItem->itemId;

			$addedItem->moreData['baseQuantity'] = (int) $item['quantity'];

			if ($baseProduct->disableStackInCart) {
				$addedItem->moreData['disableStacking'] = true;
			}

			if ($item['note'] && $item['note']['noteCheck'] === 'yes') {
				$addedItem->moreData['note'] = $item['note']['note'];
			}

			$this->eventDispatcher->dispatch(new AddedCartItemEvent($addedItem), 'eshopOrders.cartAddItem');
		}

		$this->payload->cartLink = $this->link(':EshopOrders:Front:Default:order');
		$this->sendPayload();
	}
}
