<?php declare(strict_types = 1);

namespace EshopPackages\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TTranslateListener;
use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\ArrayHash;

/**
 * @ORM\Table("eshop_package__editable_package")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class EditablePackage
{
	use TId;
	use TTranslateListener;
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'eshopPackageEditablePackage';

	/**
	 * @var Collection<string, EditablePackageText>
	 * @ORM\OneToMany(targetEntity="EditablePackageText", mappedBy="package", indexBy="lang")
	 */
	protected Collection $texts;

	/**
	 * @var Collection<int, EditablePackageBox>
	 * @ORM\OneToMany(targetEntity="EditablePackageBox", mappedBy="package", indexBy="product_id")
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public Collection $boxes;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $icon = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $categories = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $manufacturers = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $features = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $categories2 = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $manufacturers2 = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $features2 = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=true)
	 */
	public ?int $maxProducts = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=true)
	 */
	public ?int $maxValueLimit = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=true)
	 */
	public ?int $minValueLimit = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=true)
	 */
	public ?int $valueFeature = null;

	/**
	 * @var array|ArrayHash|null
	 * @ORM\Column(type="array", nullable=true)
	 */
	protected $attrs;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false, options={"default": "products"})
	 */
	public string $limitType = 'products';

	public function __construct()
	{
		$this->texts = new ArrayCollection;
		$this->boxes = new ArrayCollection;
		$this->attrs = [];
	}

	/**
	 * @return Collection<string, EditablePackageText>
	 */
	public function getTexts(): Collection { return $this->texts; }

	/**
	 * @param string|null $lang
	 *
	 * @return EditablePackageText|null
	 */
	public function getText(?string $lang = null): ?EditablePackageText { return $this->texts->get($lang ?: $this->locale) ?? null; }

	public function setTexts(array $texts): void { $this->texts = new ArrayCollection($texts); }

	public function getCategories(): array { return $this->categories ? explode('|', (string) $this->categories) : []; }

	public function setCategories(array $arr): void { $this->categories = implode('|', $arr); }

	public function getManufacturers(): array { return $this->manufacturers ? explode('|', (string) $this->manufacturers) : []; }

	public function setManufacturers(array $arr): void { $this->manufacturers = implode('|', $arr); }

	public function getFeatures(): array { return $this->features ? explode('|', (string) $this->features) : []; }

	public function setFeatures(array $arr): void { $this->features = implode('|', $arr); }

	public function getCategories2(): array { return $this->categories2 ? explode('|', (string) $this->categories2) : []; }

	public function setCategories2(array $arr): void { $this->categories2 = implode('|', $arr); }

	public function getManufacturers2(): array { return $this->manufacturers2 ? explode('|', (string) $this->manufacturers2) : []; }

	public function setManufacturers2(array $arr): void { $this->manufacturers2 = implode('|', $arr); }

	public function getFeatures2(): array { return $this->features2 ? explode('|', (string) $this->features2) : []; }

	public function setFeatures2(array $arr): void { $this->features2 = implode('|', $arr); }

	public function getAttrs(): array { return $this->attrs ?: []; }

	/**
	 * @return mixed|null
	 */
	public function getAttr(string $key) { return $this->attrs[$key] ?? null; }

	public function setAttr(string $key, string $value): void { $this->attrs[$key] = $value; }

	public function removeAttr(string $key): void { unset($this->attrs[$key]); }

}
