<?php declare(strict_types = 1);

namespace EshopPackages\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_package__editable_package_box")
 * @ORM\Entity
 */
class EditablePackageBox
{
	/**
	 * @ORM\Id
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="EditablePackage", inversedBy="boxes")
	 * @ORM\JoinColumn(name="package_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected EditablePackage $package;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	public int $position = 0;

	public function __construct(EditablePackage $package, Product $product)
	{
		$this->package = $package;
		$this->product = $product;
		$this->setPosition(-1);
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPackage(): EditablePackage { return $this->package; }

	public function getProduct(): Product { return $this->product; }
}
