<?php declare(strict_types = 1);

namespace EshopPackages\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_package__editable_package_text")
 * @ORM\Entity
 */
class EditablePackageText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EditablePackage", inversedBy="texts")
	 * @ORM\JoinColumn(name="package_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected EditablePackage $package;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	public string $lang;

	/**
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $shortTitle = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $text = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $videoLink = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $btnText = null;

	public function __construct(EditablePackage $package, string $lang, string $title)
	{
		$this->package = $package;
		$this->lang    = $lang;
		$this->title   = $title;
	}

	public function getPackage(): EditablePackage { return $this->package; }

}
