<?php declare(strict_types = 1);

namespace EshopPackages\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class EshopPackagesCache
{
	public const cacheNamespace = 'eshopPackages';

	protected Cache $cache;

	public function __construct(
		Storage $storage
	)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	/**
	 * @param string|int $ident
	 */
	public static function getKey($ident, string $lang): string
	{
		return implode(':', ['eshopPackages', $ident, $lang]);
	}

	public function getCache(): Cache { return $this->cache; }
}
