<?php declare(strict_types = 1);

namespace EshopPackages\Model;

use Nettrine\ORM\EntityManagerDecorator;

class Helper
{
	protected EntityManagerDecorator $em;

	protected ?array $cAll = null;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function getProductByEditablePackage(int $packageId): ?int
	{
		$productId = $this->em->getConnection()->fetchOne("SELECT product_id FROM eshop_package__editable_package_box WHERE package_id = :packageId ORDER BY `position` ASC", [
			'packageId' => $packageId,
		]);

		return $productId ? (int) $productId : null;
	}

	public function getAllProductIds(): array
	{
		if ($this->cAll === null) {
			$this->cAll = [];

			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT product_id FROM eshop_package__editable_package_box") as $row) {
				/** @var array $row */
				$this->cAll[] = (int) $row['product_id'];
			}
		}

		return $this->cAll;
	}
}
