<?php declare(strict_types = 1);

namespace EshopPackages\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Helpers\FormHelper;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use EshopPackages\AdminModule\Model\Services\EditablePackagesService as AdminEditablePackages;
use EshopPackages\Model\Services\EditablePackagesService;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\AdminModule\Model\TemplatePages;

class EditablePackage extends BaseNavigation implements INavigationItem
{
	public const TEMPLATES_DIR = 'EshopPackages/EditablePackages';

	protected $title     = 'editablePackage';
	protected $presenter = 'EshopPackages:Front:Default';
	protected $action    = 'editablePackage';

	/** @var string */
	protected $navFormSite;

	protected AdminEditablePackages $adminEditablePackages;

	protected EditablePackagesService $editablePackages;
	protected TemplatePages           $templatePagesService;

	public function __construct(
		AdminEditablePackages   $adminEditablePackages,
		EditablePackagesService $editablePackages,
		TemplatePages           $templatePages
	)
	{
		$this->adminEditablePackages = $adminEditablePackages;
		$this->editablePackages      = $editablePackages;
		$this->templatePagesService  = $templatePages;
	}

	/**
	 * @inheritdoc
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer;

		$container->addSelect('templatePage', 'eshopPackages.navigationForm.page', FormHelper::getTemplateFiles(self::TEMPLATES_DIR));
		$container->addSelect('templatePage2', 'eshopPackages.navigationForm.page2', ['' => ''] + $this->templatePagesService->getOptionsForSelectGrouped());
		$container->addSelect('package', 'eshopPackages.navigationForm.package', $this->adminEditablePackages->getOptionsForSelect())
			->setRequired();

		return $container;
	}

	/**
	 * @inheritdoc
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	public static function getPackageTemplate(string $file): string
	{
		$tmp = explode('|', $file);

		$site = 'default';
		if (count($tmp) == 2) {
			$file = $tmp[1];
			$site = $tmp[0];
		}

		return TEMPLATES_DIR . DS . 'Front' . DS . $site . DS . EditablePackage::TEMPLATES_DIR . DS . $file . '.latte';
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	/**
	 * @inheritdoc
	 */
	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @inheritdoc
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		if ($urlParams['path']) {
			$tmp = explode('/', $urlParams['path']);

			if (end($tmp) !== $navigation->alias) {
				return null;
			}
		}

		$package = $this->editablePackages->get((int) $navigation->componentParams['package']);

		if ($package) {
			return [
				'presenter' => $this->presenter,
				'action'    => $this->action,
				'id'        => $package->getId(),
			];
		}

		return null;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if ($urlParams['id'] && $urlParams['id'] == $navigation->componentParams['package'] || $urlParams['activeNavigation']) {
			return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
		}

		return null;
	}
}
