<?php declare(strict_types = 1);

namespace EshopPackages\Model\Services;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query\Expr\Join;
use EshopPackages\Model\Entities\EditablePackage;

class EditablePackagesService extends BaseFrontEntityService
{
	protected       $entityClass = EditablePackage::class;
	protected array $cPackages   = [];

	public function get(int $id): ?EditablePackage
	{
		if (!isset($this->cPackages[$id])) {
			$this->cPackages[$id] = $this->getEr()->createQueryBuilder('ep')
				->addSelect('ept')
				->innerJoin('ep.texts', 'ept', Join::WITH, 'ept.lang = :lang')
				->where('ep.id = :id')
				->setParameters([
					'id'   => $id,
					'lang' => $this->translator->getLocale(),
				])
				->setMaxResults(1)->getQuery()->getOneOrNullResult();
		}

		return $this->cPackages[$id];
	}
}
