<?php declare(strict_types = 1);

namespace EshopPackages\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\FrontPresenter;
use EshopOrders\FrontModule\Model\Dao\CartItem;
use EshopOrders\FrontModule\Model\Event\AddedCartItemEvent;
use EshopOrders\FrontModule\Presenters\DefaultPresenter;
use EshopPackages\Model\Helper;
use Gallery\FrontModule\Model\Dao\Image;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopOrders\FrontModule\Model\Carts;
use Contributte\Translation\Translator;

class CartSubscriber implements EventSubscriberInterface
{
	protected Carts $cartsService;
	protected Translator $translator;
	protected Helper $helper;
	protected array $cartChanges = [];

	public function __construct(Carts $carts, Translator $translator, Helper $helper)
	{
		$this->cartsService = $carts;
		$this->translator   = $translator;
		$this->helper       = $helper;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::beforeRender'   => 'beforeRender',
			'eshopOrders.cartAddItem'                  => ['onAddItem', 100],
			DefaultPresenter::class . '::beforeRender' => 'defaultBeforeRender',
		];
	}

	public function defaultBeforeRender(ControlEvent $event): void
	{
	}

	public function beforeRender(ControlEvent $event): void
	{
		if (!isset($this->cartChanges['added'])) {
			return;
		}

		$hasClassicProduct = false;
		$hasPackage        = false;
		$allProductIds     = $this->helper->getAllProductIds();

		foreach ($this->cartsService->getCurrentCart()->getCartItems() as $item) {
			if ($item->getProduct() && in_array($item->getProduct()->getId(), $allProductIds)) {
				$hasPackage = true;
			}
			else {
				$hasClassicProduct = true;
			}
		}

		if ($hasClassicProduct && $hasPackage) {
			$event->control->getPresenter()->payload->eshopPackageShowClassicProductNotify = true;
		}
	}

	public function onAddItem(AddedCartItemEvent $event): void
	{
		$item                         = &$event->item;
		$this->cartChanges['added'][] = $item;
	}
}
