<?php declare(strict_types = 1);

namespace EshopPackages\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use EshopOrders\FrontModule\Components\Order\OrderForm;
use EshopOrders\FrontModule\Model\Carts;
use EshopPackages\Model\Helper;
use Nette\Localization\ITranslator;
use Nette\Utils\Html;
use Nette\Utils\Strings;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderFormSubscriber implements EventSubscriberInterface
{
	protected Carts $carts;

	protected ITranslator $translator;

	protected Helper $helper;

	public function __construct(Carts $carts, ITranslator $translator, Helper $helper)
	{
		$this->carts      = $carts;
		$this->translator = $translator;
		$this->helper     = $helper;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			OrderForm::class . '::onAttach' => 'orderFormAttach',
		];
	}

	public function orderFormAttach(ControlEvent $event): void
	{
		/** @var OrderForm $control */
		$control = $event->control;

		$allProductIds = $this->helper->getAllProductIds();
		$hasPackage    = false;
		foreach ($this->carts->getCurrentCart()->getCartItems() as $item) {
			if ($item->getProduct() && in_array($item->getProduct()->getId(), $allProductIds)) {
				$hasPackage = true;
				break;
			}
		}

		if ($hasPackage) {
			$event->control->template->deliveryAndInvoiceInfoSubtitle = Html::el('div class="eshop-packages__cart-title-wrap"')
				->addHtml(
					Html::el('div class="eshop-packages__cart-title"')
						->addHtml(Html::el('span')->setText($this->translator->translate('eshopPackagesFront.cart.invoiceTitle')))
				);
			$event->control->template->deliveryInfoSubtitle           = Html::el('div class="eshop-packages__cart-title-wrap"')
				->addHtml(
					Html::el('div class="eshop-packages__cart-title eshop-packages__cart-title--2"')
						->addHtml(Html::el('i class="eshop-packages__gift-ico"'))
						->addHtml(Html::el('span')->setText($this->translator->translate('eshopPackagesFront.cart.deliveryTitle')))
				);
		}
	}
}
