<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use EshopPackages\Model\Entities\EditablePackage;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251114103013 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_package__editable_package_box (package_id INT NOT NULL, product_id INT NOT NULL, INDEX IDX_E56F3BFCF44CABFF (package_id), INDEX IDX_E56F3BFC4584665A (product_id), PRIMARY KEY(package_id, product_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_package__editable_package_box ADD position INT NOT NULL');
		$this->addSql('ALTER TABLE eshop_package__editable_package_box ADD CONSTRAINT FK_E56F3BFCF44CABFF FOREIGN KEY (package_id) REFERENCES eshop_package__editable_package (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_package__editable_package_box ADD CONSTRAINT FK_E56F3BFC4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$positions = [];
		foreach ($this->connection->fetchAllAssociative("SELECT id, section_key, `value` 
				FROM core__extra_field
				WHERE section_name = :sectionName AND `key` = :key", [
			'sectionName' => EditablePackage::EXTRA_FIELD_SECTION,
			'key'         => 'productId',
		]) as $row) {
			$packageId = (int) $row['section_key'];
			$productId = (int) $row['value'];

			if (!isset($positions[$packageId])) {
				$positions[$packageId] = 0;
			}

			$this->connection->insert('eshop_package__editable_package_box', [
				'package_id' => $packageId,
				'product_id' => $productId,
				'position'   => $positions[$packageId]++,
			]);
			$this->connection->delete('core__extra_field', ['id' => $row['id']]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('DROP TABLE eshop_package__editable_package_box');
	}
}
