<?php declare(strict_types=1);

namespace EshopPayments\AdminModule\Model\Events;

use EshopCatalog\Model\Entities\SellerBankAccount;
use EshopPayments\Model\Entities\IPayment;
use EshopPayments\Model\Entities\Payment;
use Symfony\Contracts\EventDispatcher\Event;

class PaymentSyncEvent extends Event
{
	protected ?Payment $lastSyncedPayment;
	protected SellerBankAccount $sellerBankAccount;

	/** @var IPayment[] */
	public array $paymentsToSync = [];

	public function __construct(SellerBankAccount $sellerBankAccount, ?Payment $lastSyncedPayment)
	{
		$this->sellerBankAccount = $sellerBankAccount;
		$this->lastSyncedPayment = $lastSyncedPayment;
	}

	public function getLastSyncedPayment(): ?Payment
	{
		return $this->lastSyncedPayment;
	}

	public function getSellerBankAccount(): SellerBankAccount
	{
		return $this->sellerBankAccount;
	}

}