<?php declare(strict_types = 1);

namespace EshopPayments\AdminModule\Presenters;

use EshopCatalog\Model\Entities\SellerBankAccount;
use EshopPayments\AdminModule\Components\IPaymentsOverviewGridFactory;
use FioApi\Downloader;
use Nette\Application\UI\Multiplier;

class DefaultPresenter extends BasePresenter
{
	/** @var SellerBankAccount[]|null */
	protected ?array $sellerBankAccounts = null;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->translator->translate('eshopPayments.title.eshopPayments'));
		$this->setHeader('eshopPayments.title.eshopPayments', 'fas fa-file-invoice-dollar');
		$this->template->sellerBankAccounts = $this->getSellerBankAccounts();
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	public function createComponentPaymentsOverviewGrid(IPaymentsOverviewGridFactory $factory): Multiplier
	{
		$accounts = $this->getSellerBankAccounts();
		return new Multiplier(function (string $sellerBankAccountId) use ($factory, $accounts) {
			return $factory->create($accounts[(int) $sellerBankAccountId]);
		});
	}

	/**
	 * @return SellerBankAccount[]
	 */
	public function getSellerBankAccounts(): array
	{
		$arr = [];
		if ($this->sellerBankAccounts !== null) {
			return $arr;
		}
		/** @var SellerBankAccount $value */
		foreach ($this->em->getRepository(SellerBankAccount::class)->findBy([], ['bankName' => 'asc']) as $value) {
			if (empty($value->numberPart1) || empty($value->numberPart2)) {
				continue;
			}
			$arr[$value->getId()] = $value;
		}
		return $arr;
	}

}
