<?php declare(strict_types = 1);

namespace EshopPayments\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\DI\Compiler;
use Nette\Schema\Expect;
use Nette\Schema\Schema;
use Nette\Utils\DateTime;

class EshopPaymentsExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopPayments' => 'EshopPayments\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopPayments\Model\EshopPaymentsConfig::setParams($this->parameters[\'eshopPayments\'] ?? []);');
	}
}
