<?php declare(strict_types=1);

namespace EshopPayments\Model\Entities;

use DateTimeInterface;
use EshopCatalog\Model\Entities\SellerBankAccount;

interface IPayment
{
	public function getAmount(): float;
	public function getDateOfPayment(): ?DateTimeInterface;
	public function getSenderAccountNumber(): ?string;
	public function getSenderBankCode(): ?string;
	public function getSenderBankName(): ?string;
	public function getSenderName(): ?string;
	public function getConstantSymbol(): ?string;
	public function getVariableSymbol(): ?string;
	public function getSpecificSymbol(): ?string;
	public function getUserMessage(): ?string;
	public function getComment(): ?string;
	public function getPaymentOrderId(): ?string;
	public function getBankAccount(): SellerBankAccount;
}