<?php declare(strict_types=1);

namespace EshopPayments\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\SellerBankAccount;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_payments__payment")
 * @ORM\Entity
 */
class Payment
{
	use TId;

	/**
	 * @var float|string
	 * @ORM\Column(type="decimal", nullable=false, precision=10, scale=2)
	 */
	public $amount;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $dateOfPayment;

	/**
	 * @ORM\Column(type="datetime", nullable=false, options={"default":"CURRENT_TIMESTAMP"})
	 */
	public DateTimeInterface $inserted;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $senderAccountNumber;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $senderBankCode;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $senderBankName;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $senderName;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $constantSymbol;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $variableSymbol;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $specificSymbol;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $userMessage;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $comment;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $paymentOrderId;

	/**
	 * @ORM\ManyToOne(targetEntity="\EshopCatalog\Model\Entities\SellerBankAccount")
	 * @ORM\JoinColumn(name="bank_account_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public SellerBankAccount $bankAccount;

	/**
	 * @ORM\ManyToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
	 */
	public ?Order $order;

	/**
	 * @ORM\ManyToOne(targetEntity="Status")
	 * @ORM\JoinColumn(name="status_id", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	public Status $status;

	/**
	 * Payment constructor.
	 * @param string|float $amount
	 * @param SellerBankAccount $bankAccount
	 */
	public function __construct($amount, string $paymentOrderId, SellerBankAccount $bankAccount)
	{
		$this->amount = $amount;
		$this->paymentOrderId = $paymentOrderId;
		$this->bankAccount = $bankAccount;
		$this->inserted = new DateTime;
	}

}