<?php declare(strict_types=1);

namespace EshopPayments\Model\Repository;

use Core\Model\Event\EventDispatcher;
use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\SellerBankAccount;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopPayments\AdminModule\Model\Events\PaymentSyncEvent;
use EshopPayments\Model\Entities\IPayment;
use EshopPayments\Model\Entities\Payment;
use Nette\Utils\DateTime;
use Tracy\Debugger;

/**
 * @method Payment|null get(int $id)
 * @method Payment[] getAll()
 */
class Payments extends BaseEntityService
{
	protected $entityClass = Payment::class;

	/**
	 * @return Payment[]
	 */
	public function getBy(string $paymentOrderId): array
	{
		$qb = $this->getEr()->createQueryBuilder('p');
		$qb->where('p.paymentOrderId = :paymentOrderId')
			->setParameters([
				'paymentOrderId' => $paymentOrderId,
			]);

		return $qb->getQuery()->getResult();
	}

}