<?php declare(strict_types=1);

namespace EshopPayments\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use EshopPayments\Model\Entities\Status;

/**
 * Class Statuses
 * @package EshopPayments\Model\Repository
 * @method Status|null get(string $id)
 * @method Status[] getAll()
 */
class Statuses extends BaseEntityService
{
	protected $entityClass = Status::class;

	/**
	 * @return Status[] Key is ident
	 */
	public function getAssoc(): array
	{
		$result = [];
		/** @var Status $value */
		foreach ($this->getAll() as $value) {
			$result[$value->ident] = $value;
		}

		return $result;
	}

}