<?php declare(strict_types = 1);

namespace EshopPayments\Model\Utils;

use Core\Model\Helpers\Strings;

class Numbers
{
	/**
	 * @return int|float
	 */
	public static function keepDecimals(float $num, int $dec)
	{
		$replace = str_replace(',', '.', (string) $num);
		$decimals = explode('.', $replace);

		if (count($decimals) > 1 && Strings::contains($replace, '.')) {
			return (float) (sprintf('%s.%s', (int) $num, substr($decimals[1], 0, $dec)));
		}

		return (int) $num;
	}
}