<?php

declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210206190304 extends AbstractMigration
{
	public function getDescription() : string
	{
		return '';
	}

	public function up(Schema $schema) : void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE eshop_payments__payment (id INT AUTO_INCREMENT NOT NULL, bank_account_id INT NOT NULL, order_id INT DEFAULT NULL, status_id VARCHAR(255) NOT NULL, amount NUMERIC(10, 2) NOT NULL, date_of_payment DATETIME DEFAULT NULL, inserted DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, sender_account_number VARCHAR(255) DEFAULT NULL, sender_bank_code VARCHAR(255) DEFAULT NULL, sender_bank_name VARCHAR(255) DEFAULT NULL, sender_name VARCHAR(255) DEFAULT NULL, constant_symbol VARCHAR(255) DEFAULT NULL, variable_symbol VARCHAR(255) DEFAULT NULL, specific_symbol VARCHAR(255) DEFAULT NULL, user_message VARCHAR(255) DEFAULT NULL, comment VARCHAR(255) DEFAULT NULL, payment_order_id VARCHAR(255) NOT NULL, INDEX IDX_DB26F93012CB990C (bank_account_id), INDEX IDX_DB26F9308D9F6D38 (order_id), INDEX IDX_DB26F9306BF700BD (status_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_payments__status (ident VARCHAR(255) NOT NULL, PRIMARY KEY(ident)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_payments__payment ADD CONSTRAINT FK_DB26F93012CB990C FOREIGN KEY (bank_account_id) REFERENCES eshop_catalog__seller_bank_account (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_payments__payment ADD CONSTRAINT FK_DB26F9308D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_payments__payment ADD CONSTRAINT FK_DB26F9306BF700BD FOREIGN KEY (status_id) REFERENCES eshop_payments__status (ident) ON DELETE CASCADE');

		$this->addSql('INSERT INTO eshop_payments__status (`ident`) VALUES (\'returned\');');
		$this->addSql('INSERT INTO eshop_payments__status (`ident`) VALUES (\'syncedAuto\');');
		$this->addSql('INSERT INTO eshop_payments__status (`ident`) VALUES (\'syncedManual\');');
		$this->addSql('INSERT INTO eshop_payments__status (`ident`) VALUES (\'unsynced\');');
	}

	public function down(Schema $schema) : void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_payments__payment DROP FOREIGN KEY FK_DB26F9306BF700BD');
		$this->addSql('DROP TABLE eshop_payments__payment');
		$this->addSql('DROP TABLE eshop_payments__status');
	}
}
