<?php declare(strict_types = 1);

namespace EshopPrices\AdminModule\Presenters;

use EshopPrices\AdminModule\Components\DiscountsGrid;
use EshopPrices\AdminModule\Components\IDiscountsGridFactory;

class DefaultPresenter extends BasePresenter
{
	/**
	 * @return void
	 */
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopPrices.title.prices', 'fas fa-money-bill-alt');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopPrices.menu.addDiscount',
				'link'  => $this->link('discountsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentDiscountsGrid(IDiscountsGridFactory $factory): DiscountsGrid
	{
		return $factory->create();
	}
}
