<?php declare(strict_types = 1);

namespace EshopPrices\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;

class EshopPricesExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopPrices' => 'EshopPrices\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopPrices\Model\EshopPricesConfig::setParams(?);', [$builder->parameters['eshopPrices'] ?? []]);
	}
}
