<?php declare(strict_types = 1);

namespace EshopPrices\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopPrices\Model\Entities\Discount;
use Nette\Caching\Cache;

class Discounts extends BaseFrontEntityService
{
	public const CACHE_NAMESPACE = 'eshopCatalogFeatures';

	protected $entityClass = Discount::class;
	protected CacheService $cacheService;
	protected ?array $cPublished = null;
	protected array $cacheDep = [
		Cache::TAGS   => ['features'],
		Cache::EXPIRE => '2 weeks',
	];

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public function getPublished(): array
	{
		if ($this->cPublished === null) {
			$this->cPublished = [];

			foreach ($this->getEr()->createQueryBuilder('d')
				         ->andWhere('d.isActive = 1')
				         ->getQuery()->getArrayResult() as $row) {
				$this->cPublished[] = [
					'discount'       => (float) $row['discount'],
					'customerGroups' => $row['customerGroups'] ? explode(',', (string) $row['customerGroups']) : [],
					'manufacturers'  => $row['manufacturers'] ? explode(',', (string) $row['manufacturers']) : [],
					'categories'     => $row['categories'] ? explode(',', (string) $row['categories']) : [],
					'features'       => $row['features'] ? explode(',', (string) $row['features']) : [],
				];
			}
		}

		return $this->cPublished;
	}
}
