<?php declare(strict_types = 1);

namespace EshopPrices\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_prices__discount")
 * @ORM\Entity
 */
class Discount
{
	use TId;

	/**
	 * @ORM\Column(name="title", type="string", nullable=true)
	 */
	public ?string $title = null;

	/**
	 * @var int|float|string
	 * @ORM\Column(name="discount", type="decimal", precision=10, scale=2, nullable=false)
	 */
	protected $discount;

	/**
	 * @ORM\Column(name="customer_groups", type="string", nullable=true)
	 */
	public ?string $customerGroups = null;

	/**
	 * @ORM\Column(name="manufacturers", type="string", nullable=true)
	 */
	public ?string $manufacturers = null;

	/**
	 * @ORM\Column(name="categories", type="string", nullable=true)
	 */
	public ?string $categories = null;

	/**
	 * @ORM\Column(name="features", type="string", nullable=true)
	 */
	public ?string $features = null;

	/**
	 * @ORM\Column(name="is_active", type="smallint", nullable=false, options={"unsigned": true, "default": 1})
	 */
	public int $isActive = 1;

	/**
	 * @param string|int|float $discount
	 */
	public function __construct($discount)
	{
		$this->setDiscount($discount);
	}

	public function getDiscount(): float { return (float) $this->discount; }

	/**
	 * @param string|int|float $discount
	 */
	public function setDiscount($discount): void
	{
		$this->discount = Strings::formatEntityDecimal($discount);
	}

	public function setCustomerGroups(array $groups): void
	{
		$this->customerGroups = implode(',', $groups);
	}

	/**
	 * @return string[]
	 */
	public function getCustomerGroups(): array { return explode(',', (string) $this->customerGroups); }

	public function setManufacturers(array $manu): void
	{
		$this->manufacturers = implode(',', $manu);
	}

	/**
	 * @return string[]
	 */
	public function getManufacturers(): array { return explode(',', (string) $this->manufacturers); }

	public function setCategories(array $cats): void
	{
		$this->categories = implode(',', $cats);
	}

	public function getCategories(): array { return explode(',', (string) $this->categories); }

	public function setFeatures(array $fea): void
	{
		$this->features = implode(',', $fea);
	}

	/**
	 * @return string[]
	 */
	public function getFeatures(): array { return explode(',', (string) $this->features); }
}
