document.addEventListener('DOMContentLoaded', () => {
	document.addEventListener('change', e => {
		const target = e.target
		const selectWrapper = target.closest('.frm__type-select')
		const select = selectWrapper?.querySelector('select')
		const source = select?.dataset.source
		const productId = select.value

		if (source && select && productId) {
			const unit = document.units[source][productId]

			// varianta, pokud je na miste jednotky pouze text
			const unitSpan = select.closest('tr')?.querySelector('.input-group-append:not(.has-unit-controls)')
			if (unitSpan && unit) {
				unitSpan.innerHTML = unit.unitText
			}

			// varianta, pokud je na miste jednotky select pro vyber vkladane jednotky
			const unitSelect = select.closest('tr')?.querySelector('.input-group-append.has-unit-controls select')
			if (unitSelect && unit) {
				unitSelect.innerHTML = ''
				const allowedUnits = unit.allowedUnits
				Object.keys(allowedUnits).forEach((key, index) => {
					const option = document.createElement('option')
					option.text = allowedUnits[key]
					option.value = key
					unitSelect.add(option)
				})
			}

			const colAveragePrice = select.closest('tr')?.querySelector('.col-average-price')
			if (colAveragePrice) {
				global.naja.makeRequest('GET', '/admin/eshop-production-warehouse/api/get-average-price', {productId}, {
					history: false,
				}).then(function (response) {
					colAveragePrice.innerHTML = response.avg
				})
			}
		}
	})
	
	document.addEventListener('editableList:beforeAppendRow', (payload) => {
		payload.detail.row.querySelectorAll('.input-group-append:not(.has-unit-controls)').forEach(el => (el.innerHTML = ''))
		payload.detail.row.querySelectorAll('.input-group-append.has-unit-controls select').forEach(el => (el.innerHTML = ''))
		payload.detail.row.querySelectorAll('.col-average-price').forEach(el => (el.innerHTML = ''))
	})
})