<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopProductionWarehouse\AdminModule\Model\Facade\BatchesFacade;
use EshopProductionWarehouse\Model\Entities\Batch;

class BatchesGrid extends BaseControl
{
	protected BatchesFacade $batchesFacade;

	public function __construct(BatchesFacade $batchesFacade)
	{
		$this->batchesFacade = $batchesFacade;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setDataSource($this->em->getRepository(Batch::class)->createQueryBuilder('b'));
		$grid->addColumnLink('name', 'eshopProductionWarehouse.batchesGrid.name', 'Batches:edit');

		$grid->addAction('clone', '', 'clone!')->setConfirm('eshopProductionWarehouse.batchesGrid.askClone')->addClass('ajax')->setIcon('copy')->setBsType('success');
		$grid->addAction('edit', '', 'Batches:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}

	/**
	 * @param string|int $id
	 */
	public function handleClone($id): void
	{
		$presenter = $this->getPresenter();

		$this->em->persist($this->batchesFacade->cloneBatch((int) $id))->flush();
		$presenter->flashMessageSuccess('default.saved');

		$this['grid']->reload();
		$presenter->redrawControl('flashes');
	}

	/**
	 * @param string|int $id
	 */
	public function handleDelete($id): void
	{
		$presenter = $this->getPresenter();

		$batch = $this->em->getRepository(Batch::class)->find((int) $id);

		if ($batch) {
			$this->em->remove($batch);
			$this->em->flush();
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageSuccess('default.removeFailed');
		}

		$this['grid']->reload();
		$presenter->redrawControl('flashes');
	}

}