<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Components;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Doctrine\ORM\QueryBuilder;
use EshopProductionWarehouse\Model\Entities\WarehouseMovement;
use Nette\Application\UI\Multiplier;

class WarehouseMovementsGrid extends BaseControl
{
	protected QueryBuilder $queryBuilder;
	protected IWarehouseMovementsDetailFactory $movementsDetailFactory;

	public function __construct(IWarehouseMovementsDetailFactory $movementsDetailFactory, EntityManagerDecorator $em)
	{
		$qb = $em->getRepository(WarehouseMovement::class)->createQueryBuilder('w');
		$qb->addOrderBy('w.date', 'desc');

		$this->queryBuilder = $qb;
		$this->movementsDetailFactory = $movementsDetailFactory;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setDataSource($this->queryBuilder);

		$grid->addColumnDateTime('date', 'eshopProductionWarehouse.warehouseMovementsGrid.date')
			 ->setAlign('left')
			 ->setFormat('d.m.Y');
		$grid->setItemsDetail(__DIR__ . '/WarehouseMovementsGridDetail.latte');
		$grid->addAction('editInputs', 'eshopProductionWarehouse.warehouseMovementsGrid.editInputs', 'editInputs')
			 ->setRenderCondition(fn(WarehouseMovement $movement) => count($movement->getInputs()) > 0)
			 ->setIcon('edit')
			 ->setBsType('primary');
		$grid->addAction('editOutputs', 'eshopProductionWarehouse.warehouseMovementsGrid.editOutputs', 'editOutputs')
			 ->setRenderCondition(fn(WarehouseMovement $movement) => count($movement->getOutputs()) > 0)
			 ->setIcon('edit')
			 ->setBsType('primary');

		return $grid;
	}

	public function createComponentWarehouseMovementDetail(): Multiplier
	{
		return new Multiplier(function($warehouseMovementId) {
			$qb = $this->queryBuilder;
			$qb->andWhere('w.id = :id')->setParameter('id', $warehouseMovementId);

			return $this->movementsDetailFactory->create($qb->getQuery()->getOneOrNullResult());
		});
	}

}