<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use EshopProductionWarehouse\Model\Entities\Warehouse;

/**
 * @method Warehouse[] getAll()
 * @method Warehouse|null get(int $id)
 */
class WarehouseRepository extends BaseEntityService
{
	protected $entityClass = Warehouse::class;

	public function findByIdent(string $warehouseIdent): ?Warehouse
	{
		return $this->em->getRepository($this->entityClass)->findOneBy(['ident' => $warehouseIdent]);
	}

	/**
	 * @return array<int, string>
	 */
	public function findPairs(): array
	{
		return $this->getEr()->findPairs([], 'name', ['name' => 'asc'], 'id');
	}

}