<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Presenters;

use Core\Model\Templating\Filters\Price as PriceFilter;
use EshopProductionWarehouse\AdminModule\Model\Facade\WarehouseFacade;

class ApiPresenter extends BasePresenter
{
	/** @var WarehouseFacade @inject */
	public WarehouseFacade $warehouseFacade;

	/** @var PriceFilter @inject */
	public PriceFilter $priceFilter;

	public function actionGetAveragePrice(int $productId): void
	{
		$avg = $this->warehouseFacade->getAveragePurchasePrice($productId);

		$this->sendJson([
			'productId' => $productId,
			'avg' => $this->priceFilter->format($avg)
		]);
	}
}