<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\Common\IOperation;

abstract class BatchItem implements IOperation
{
	protected array $extras = [];

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="cascade", nullable=false)
	 */
	protected Product $product;

	/**
	 * @ORM\ManyToOne(targetEntity="Batch")
	 * @ORM\JoinColumn(name="id_batch", referencedColumnName="id", onDelete="cascade", nullable=false)
	 */
	public Batch $batch;

	/**
	 * @var string|int|float|null
	 * @ORM\Column(type="decimal", precision=10, scale=9, nullable=false)
	 */
	protected $quantity = 0;

	public function __construct(Product $product, Batch $batch, float $quantity)
	{
		$this->product = $product;
		$this->batch = $batch;
		$this->setQuantity($quantity);
	}

	public function getQuantity(): float
	{
		return (float) $this->quantity;
	}

	public function setQuantity($quantity): IOperation
	{
		$this->quantity = (string) Strings::formatEntityDecimal($quantity);
		return $this;
	}

	public function getProduct(): Product
	{
		return $this->product;
	}

	public function setProduct(Product $product): IOperation
	{
		$this->product = $product;
		return $this;
	}

	public function getExtras(): array
	{
		return $this->extras;
	}

	public function setExtras(array $extras): self
	{
		$this->extras = $extras;
		return $this;
	}

	public function setExtra($key, $val): self
	{
		$this->extras[$key] = $val;
		return $this;
	}

}