<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\Model\Entities;

use EshopOrders\Model\Entities\Order;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_production_warehouse__warehouse_order")
 */
class WarehouseOrder
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Warehouse")
	 * @ORM\JoinColumn(name="warehouse_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
	 */
	public Warehouse $warehouse;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
	 */
	public Order $order;

	public function __construct(Warehouse $warehouse, Order $order)
	{
		$this->warehouse = $warehouse;
		$this->order = $order;
	}

}