<?php

declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use EshopProductionWarehouse\Model\Entities\NumericalSeries;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20220818103439 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE eshop_production_warehouse__numerical_series (ident VARCHAR(255) NOT NULL, counter INT DEFAULT 1 NOT NULL, PRIMARY KEY(ident)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement ADD supplier_id INT DEFAULT NULL, ADD invoice_number VARCHAR(255) DEFAULT NULL, ADD description LONGTEXT DEFAULT NULL, ADD input_number VARCHAR(255) DEFAULT NULL, ADD output_number VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement ADD CONSTRAINT FK_6B7AC72C2ADD6D8C FOREIGN KEY (supplier_id) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE');
        $this->addSql('CREATE INDEX IDX_6B7AC72C2ADD6D8C ON eshop_production_warehouse__warehouse_movement (supplier_id)');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_input ADD price NUMERIC(10, 2) DEFAULT NULL');
    }

	public function postUp(Schema $schema): void
	{
		foreach ([NumericalSeries::INPUT_NUM_SERIES_IDENT, NumericalSeries::OUTPUT_NUM_SERIES_IDENT] as $ident) {
			$this->connection->prepare("INSERT INTO eshop_production_warehouse__numerical_series (ident, counter) VALUES (?, 1)")->execute(['ident' => $ident]);
		}
	}

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('DROP TABLE eshop_production_warehouse__numerical_series');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement DROP FOREIGN KEY FK_6B7AC72C2ADD6D8C');
        $this->addSql('DROP INDEX IDX_6B7AC72C2ADD6D8C ON eshop_production_warehouse__warehouse_movement');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement DROP supplier_id, DROP invoice_number, DROP description, DROP input_number, DROP output_number');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement_input DROP price');
    }
}
