<?php

declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use EshopProductionWarehouse\Model\Entities\Warehouse;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20221107082805 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE eshop_production_warehouse__warehouse (id INT AUTO_INCREMENT NOT NULL, ident VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, UNIQUE INDEX eshop_production_ident__idx (ident), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_production_warehouse__warehouse_order (warehouse_id INT NOT NULL, order_id INT NOT NULL, INDEX IDX_176942D95080ECDE (warehouse_id), INDEX IDX_176942D98D9F6D38 (order_id), PRIMARY KEY(warehouse_id, order_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_order ADD CONSTRAINT FK_176942D95080ECDE FOREIGN KEY (warehouse_id) REFERENCES eshop_production_warehouse__warehouse (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_order ADD CONSTRAINT FK_176942D98D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement ADD warehouse_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement ADD CONSTRAINT FK_6B7AC72C5080ECDE FOREIGN KEY (warehouse_id) REFERENCES eshop_production_warehouse__warehouse (id) ON DELETE CASCADE');
        $this->addSql('CREATE INDEX IDX_6B7AC72C5080ECDE ON eshop_production_warehouse__warehouse_movement (warehouse_id)');
    }

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$this->connection->transactional(function(Connection $connection) {
			$connection->prepare("INSERT INTO eshop_production_warehouse__warehouse (ident, name) VALUES (?, ?)")
							 ->execute([Warehouse::IDENT_ESHOP_WAREHOUSE, 'Sklad eshop']);
			$eshopWarehouseId = $connection->lastInsertId();

			if (class_exists('EshopCheckout\DI\EshopCheckoutExtension')) {
				$connection->prepare("INSERT INTO eshop_production_warehouse__warehouse (ident, name) VALUES (?, ?)")
						   ->execute([Warehouse::IDENT_ESCHOPCHECKOUT_WAREHOUSE, 'Sklad prodejna']);
			}

			$stmt = $connection->prepare("SELECT id FROM eshop_orders__order");
			$stmt->execute();

			foreach ($stmt->fetchAll() as $row) {
				$connection->insert('eshop_production_warehouse__warehouse_order', [
					'warehouse_id' => $eshopWarehouseId,
					'order_id' => $row['id'],
				]);
			}

			$connection->prepare("UPDATE eshop_production_warehouse__warehouse_movement SET warehouse_id = ?")->execute([$eshopWarehouseId]);
		});
	}

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement DROP FOREIGN KEY FK_6B7AC72C5080ECDE');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_order DROP FOREIGN KEY FK_176942D95080ECDE');
        $this->addSql('DROP TABLE eshop_production_warehouse__warehouse');
        $this->addSql('DROP TABLE eshop_production_warehouse__warehouse_order');
        $this->addSql('DROP INDEX IDX_6B7AC72C5080ECDE ON eshop_production_warehouse__warehouse_movement');
        $this->addSql('ALTER TABLE eshop_production_warehouse__warehouse_movement DROP warehouse_id');
    }

}
