const initExpeditionConfirm = () => {
	document.addEventListener('click', ev => {
		const target = ev.target

		if (target.dataset.warehouseAction) {
			const form = document.getElementById('frm-orderForm-expeditionForm')
			const selectWarehouseActions = form?.querySelector('[name="warehouseActions"]')

			if (selectWarehouseActions) {
				const val = target.dataset.warehouseAction === 'null' ? '' : target.dataset.warehouseAction
				global.choicesList[selectWarehouseActions.dataset.choicesIndex].setChoiceByValue(val)
			}
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initExpeditionConfirm()
})