document.addEventListener('DOMContentLoaded', () => {
	document.querySelectorAll('.editable-list .btn-remove').forEach(btnRemove => {
		btnRemove.addEventListener('click', () => handleRemoveButton(btnRemove))
	})
	document.querySelectorAll('.editable-list .btn-add').forEach(btnAdd => {
		btnAdd.addEventListener('click', () => handleAddButton(btnAdd))
	})
})

const handleRemoveButton = (btn) => {
	if (btn.closest('tbody').children.length < 2) {
		alert('V seznamu musí zůstat alespoň 1 položka')
		return
	}

	btn.closest('tr')?.remove()
}

const handleAddButton = (btn) => {
	const list = btn.closest('.editable-list')
	const tbody = list.querySelector('tbody')

	const tr = tbody.querySelector('tr:last-child')

	if (tr && tbody) {

		/**
		 * U puvodniho radku zmena z choices na obyc select a zpet z duvodu moznosti reinicializace
		 * selectu v nove vzniklem radku, tak aby byly nainicializovany vsechny listenery a choices select
		 * fungoval tak jak ma
		 */
		let rowHasChoices = false
		let newRow = null
		const choice = global.choicesList[tr.querySelector('select[data-source]').dataset.choicesIndex]
		if (choice) {
			const val = choice.getValue(true)
			choice.destroy() // prevede choices na obyc html select
			newRow = tr.cloneNode(true)

			choice.init() // prevede obyc html select na choices
			choice.setChoiceByValue(val)
			rowHasChoices = true
		} else {
			newRow = tr.cloneNode(true)
		}

		if (newRow) {
			// vyprazdni vsechny inputy v radku
			newRow.querySelectorAll('input').forEach(el => (el.value = null))

			// nastavi unikatni name
			const id = uniqueId()
			newRow.querySelectorAll('input, select, textarea').forEach(el => {
				el.setAttribute('name', el.getAttribute('name').replace('__ident__', id + '__ident__'))
			})

			document.dispatchEvent(new CustomEvent('editableList:beforeAppendRow', {detail: {row: newRow}}))

			tbody.appendChild(newRow)
		}

		const btnRemove = tbody.querySelector('tr:last-child .btn-remove')
		if (btnRemove) {
			btnRemove.addEventListener('click', () => handleRemoveButton(btnRemove))
		}

		if (rowHasChoices) {
			// vyvolani znovuinicializace choices
			document.dispatchEvent(new CustomEvent('formInputsInit'))
		}

	}
}

const uniqueId = () => {
	var now = new Date().getTime()
	var random = Math.floor(Math.random() * 10)
	var result = now + random + ''
	return result.substring(9)
}