<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Facade;

use Core\Model\Entities\EntityManagerDecorator;
use EshopProductionWarehouse\Model\Entities\Batch;

class BatchesFacade
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function cloneBatch(int $id): Batch
	{
		/** @var Batch $batch */
		$batch = $this->em->getRepository(Batch::class)->find((int) $id);

		/** @var Batch $batchCloned */
		$batchCloned = clone $batch;
		$batchCloned->name .= ' - kopie';

		foreach ($batch->getInputs() as $input) {
			$clonedInput = clone $input;
			$clonedInput->batch = $batchCloned;
			$batchCloned->addInput($clonedInput);
		}

		foreach ($batch->getOutputs() as $output) {
			$clonedOutput = clone $output;
			$clonedOutput->batch = $batchCloned;
			$batchCloned->addOutput($clonedOutput);
		}

		return $batchCloned;
	}

}