<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Facade;

use Core\Model\Entities\EntityManagerDecorator;
use EshopProductionWarehouse\Model\Entities\NumericalSeries;

class NumericalSeriesFacade
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function getInputNumber(): string
	{
		/** @var NumericalSeries $numSeries */
		$numSeries = $this->em->getRepository(NumericalSeries::class)->find(NumericalSeries::INPUT_NUM_SERIES_IDENT);
		$year = date('y');

		return sprintf('P%s%s', $year, $numSeries->getCounter());
	}

	public function getOutputNumber(): string
	{
		/** @var NumericalSeries $numSeries */
		$numSeries = $this->em->getRepository(NumericalSeries::class)->find(NumericalSeries::OUTPUT_NUM_SERIES_IDENT);
		$year = date('y');

		return sprintf('V%s%s', $year, $numSeries->getCounter());
	}

}