<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Facade;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Entities\Product;
use EshopProductionWarehouse\AdminModule\Model\ProductExtraFields;

class RawMaterialsFacade
{
	protected Products $productRepository;
	protected ProductExtraFields $productExtraFields;
	protected Translator $translator;
	protected EntityManagerDecorator $em;

	public function __construct(Products $productRepository, ProductExtraFields $productExtraFields, Translator $translator, EntityManagerDecorator $em)
	{
		$this->productRepository = $productRepository;
		$this->productExtraFields = $productExtraFields;
		$this->translator = $translator;
		$this->em = $em;
	}

	/**
	 * @return array<array{
	 *        id: int,
	 *        name: string,
	 *        units: string,
	 *        enabledNegativeQuantity: bool
	 * }>
	 */
	public function getAll(): array
	{
		$lang = $this->translator->getLocale();

		$qb = $this->productRepository->getEr()->createQueryBuilder('p');
		$qb->select('p.id, txt.name, p.units')
		   ->addSelect(sprintf('(%s) as HIDDEN isProductionRawMaterial', $this->productExtraFields->getIsProductionRawMaterialQb()->getDQL()))
		   ->addSelect(sprintf('(%s) as enabledNegativeQuantity', $this->productExtraFields->getEnabledNegativeQuantityQb()->getDQL()))
		   ->join('p.productTexts', 'txt', Join::WITH, 'txt.id = p.id AND txt.lang = :lang')
		   ->orderBy('txt.name')
		   ->andHaving('isProductionRawMaterial = \'1\'')
		   ->setParameters([
			   'key'   => 'isProductionRawMaterial',
			   'key2'  => 'enabledNegativeQuantity',
			   'value' => '1',
			   'sn'    => Product::EXTRA_FIELD_SECTION,
			   'lang'  => $lang
		   ]);

		$result = [];
		foreach ($qb->getQuery()->getArrayResult() as $item) {
			$item['enabledNegativeQuantity'] = (bool) $item['enabledNegativeQuantity'];
			$result[$item['id']] = $item;
		}

		return $result;
	}

}