<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\Facade;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use Users\Model\Entities\Acl;
use Users\Model\Entities\User;

class UsersFacade
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	/**
	 * @return array<int, string>
	 */
	public function getUsersWithPackingPrivilegePairs(): array
	{
		$expr = $this->em->getExpressionBuilder();

		$result = [];
		$users = $this->em->getRepository(User::class)->createQueryBuilder('u')
						->select("u.id, CONCAT(u.lastname, ' ', u.name) fullname")
						->join('u.roles', 'r')
						->where($expr->in('r.id', $this->em->createQueryBuilder()->select('IDENTITY(acl.role)')
														   ->from(Acl::class, 'acl')
														   ->innerJoin('acl.privilege', 'aclP', Join::WITH, 'aclP.name = :aclPName')
														   ->innerJoin('acl.resource', 'aclR', Join::WITH, 'aclR.name = :aclRName')
														   ->getDQL()))
						->orderBy('fullname')
						->setParameters([
							'aclPName' => 'packing',
							'aclRName' => 'EshopProductionWarehouse:Admin',
						])->getQuery()->getArrayResult();

		foreach ($users as $user) {
			$result[$user['id']] = $user['fullname'];
		}

		return $result;
	}

}