<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model\FormContainers\ProductsContainer;

class ProductsContainerConfig
{
	public const ALLOW_UNIT_CONVERSION = 'allowUnitConversion';
	public const ALLOW_PURCHASE_PRICE = 'allowPurchasePrice';
	public const ALLOW_MULTIPLE_IDENTICAL_PRODUCTS = 'allowMultipleIdenticalProducts';

	public bool $allowPurchasePrice;
	public bool $allowUnitConversion;
	public bool $allowMultipleIdenticalProducts;

	public function __construct(bool $allowUnitConversion, bool $allowPurchasePrice, bool $allowMultipleIdenticalProducts = true)
	{
		$this->allowUnitConversion = $allowUnitConversion;
		$this->allowPurchasePrice = $allowPurchasePrice;
		$this->allowMultipleIdenticalProducts = $allowMultipleIdenticalProducts;
	}

	public static function create(array $options = []): ProductsContainerConfig
	{
		return new self(
			$options[static::ALLOW_UNIT_CONVERSION] ?? false,
				$options[static::ALLOW_PURCHASE_PRICE] ?? false,
				$options[static::ALLOW_MULTIPLE_IDENTICAL_PRODUCTS] ?? true,
		);
	}
}