<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Entities\ExtraField;
use Doctrine\ORM\QueryBuilder;

class ProductExtraFields
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function getIsProductionRawMaterialQb(string $valueComparison = 'ef.value = :value'): QueryBuilder
	{
		$isProductionRawMaterialQb = $this->em->getRepository(ExtraField::class)->createQueryBuilder('ef');
		$isProductionRawMaterialQb->select('ef.value')
								  ->andWhere('ef.key = :key')
								  ->andWhere('(ef.lang = :lang OR ef.lang IS NULL)')
								  ->andWhere('ef.sectionName = :sn')
								  ->andWhere($valueComparison)
								  ->andWhere('ef.sectionKey = p.id');

		return $isProductionRawMaterialQb;
	}

	public function getEnabledNegativeQuantityQb(array $productIds = null): QueryBuilder
	{
		$enabledNegativeQuantityQb = $this->em->getRepository(ExtraField::class)->createQueryBuilder('ef2');
		$enabledNegativeQuantityQb->select('ef2.value')
								  ->andWhere('ef2.key = :key2')
								  ->andWhere('(ef2.lang = :lang OR ef2.lang IS NULL)')
								  ->andWhere('ef2.sectionName = :sn');

		if (is_array($productIds)) {
			$enabledNegativeQuantityQb->andWhere('ef2.sectionKey IN (:productIds)')
									  ->setParameter('productIds', $productIds);
		} else {
			$enabledNegativeQuantityQb->andWhere('ef2.sectionKey = p.id');
		}

		return $enabledNegativeQuantityQb;
	}

}