<?php declare(strict_types = 1);

namespace EshopProductionWarehouse\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use EshopProductionWarehouse\AdminModule\Components\BatchesGrid;
use EshopProductionWarehouse\AdminModule\Components\BatchForm;
use EshopProductionWarehouse\AdminModule\Components\IBatchesGridFactory;
use EshopProductionWarehouse\AdminModule\Components\IBatchFormFactory;
use EshopProductionWarehouse\Model\Entities\Batch;

class BatchesPresenter extends BasePresenter
{
	protected ?Batch $batch = null;

	public function actionDefault(): void
	{
		$this->setHeader('eshopProductionWarehouse.title.batches', 'fas fa-layer-group');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopProductionWarehouse.menu.addBatch',
				'link'  => 'Batches:add',
				'ico'   => 'plus'
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setHeader('eshopProductionWarehouse.title.addBatch', 'fas fa-layer-group');
	}

	/**
	 * @param int|string $id
	 */
	public function actionEdit($id): void
	{
		$this->batch = $this->em->getRepository(Batch::class)->find((int) $id);
		$this->setHeader($this->batch->name, 'fas fa-layer-group');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	public function createComponentBatchesGrid(IBatchesGridFactory $factory): BatchesGrid
	{
		return $factory->create();
	}

	public function createComponentBatchForm(IBatchFormFactory $factory): BatchForm
	{
		$control = $factory->create();

		if ($this->batch) {
			$control->setBatch($this->batch);
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			if ($form->getCustomData('id')) {
				$this->redirect('edit', ['id' => $form->getCustomData('id')]);
			}
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->presenter->redirect('default');
		};

		return $control;
	}

}